﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using RevisionAnalyser.Global;
using RevisionAnalyser.Projects.RecoderProject.Tasks;

namespace RevisionAnalyser.Projects.RecoderProject
{
    public partial class ManageForm : Form
    {
        private RecoderProject _project = (RecoderProject)CurrentProject.Instance.Project;

        public ManageForm()
        {
            InitializeComponent();
        }

        private void LoadRevisions(List<Revision> revisions, int imageIndex)
        {
            foreach (SvnRevision revision in revisions)
            {
                ListViewItem item = new ListViewItem();
                item.ImageIndex = imageIndex;
                item.SubItems.Add(revision.ID.ToString());
                item.SubItems.Add(revision.Author);
                item.SubItems.Add(revision.Time.ToString());
                item.SubItems.Add(revision.LogMessage);
                uxRevisionList.Items.Add(item);
            }
            if (uxRevisionList.Items.Count > 0)
            {
                HidePanel();
            }
            ManageForm_SizeChanged(null, null);
        }

        private void LoadRevisions()
        {
            LoadRevisions(_project.RevisionSet.GetRevisionList(), -1);
        }

        private void Start()
        {
            List<Task> tasks = new List<Task>();
            foreach (ListViewItem item in uxRevisionList.Items)
            {
                // We are looking for list items with an image (either 0 = add or 1 = delete).
                if (item.ImageIndex >= 0)
                {
                    long id = long.Parse(item.SubItems[1].Text);
                    if (item.ImageIndex == 0)
                    {
                        DateTime time;
                        string author = item.SubItems[2].Text;
                        DateTime.TryParse(item.SubItems[3].Text, out time);
                        string logMessage = item.SubItems[4].Text;
                        tasks.Add(new AddTask(id, author, time, logMessage));
                    }
                    else
                    {
                        tasks.Add(new RemoveTask(id));
                    }
                }
            }
            if (tasks.Count > 0)
            {
                tasks.Add(new SynchronizeTask());
                TasksForm frmTasks = new TasksForm(tasks, false);
                frmTasks.ShowDialog();
            }
            DialogResult = DialogResult.OK;
            Close();
        }

        private void AddRevisions()
        {
            AddRevisionForm frmAddRevision = new AddRevisionForm(GetRevisionList());
            if (frmAddRevision.ShowDialog() == DialogResult.OK)
            {
                LoadRevisions(frmAddRevision.GetSelectedRevisions(), 0);
            }
        }

        private List<long> GetRevisionList()
        {
            List<long> list = new List<long>();
            foreach (ListViewItem item in uxRevisionList.Items)
            {
                try
                {
                    list.Add(long.Parse(item.SubItems[1].Text));
                }
                catch
                {
                }
            }
            return list;
        }

        private void ShowPanel()
        {
            uxInfoPanel.Visible = true;
        }

        private void HidePanel()
        {
            uxInfoPanel.Visible = false;
        }

        private void DeleteItems()
        {
            foreach (ListViewItem item in uxRevisionList.SelectedItems)
            {
                if (item.ImageIndex == 0)
                {
                    uxRevisionList.Items.Remove(item);
                }
                else
                {
                    item.ImageIndex = 1;
                }
            }
            if (uxRevisionList.Items.Count == 0)
            {
                ShowPanel();
            }
            uxRevisionList_SelectedIndexChanged(null, null);
        }

        private void UndeleteItems()
        {
            uxRevisionList.BeginUpdate();
            foreach (ListViewItem item in uxRevisionList.SelectedItems)
            {
                if (item.ImageIndex == 1)
                {
                    item.ImageIndex = -1;
                }
            }
            uxRevisionList.EndUpdate();
            uxRevisionList_SelectedIndexChanged(null, null);
        }

        private void uxAddButton_Click(object sender, EventArgs e)
        {
            AddRevisions();
        }

        private void ManageForm_Load(object sender, EventArgs e)
        {
            LoadRevisions();
            ManageForm_SizeChanged(sender, e);
        }

        private void ManageForm_SizeChanged(object sender, EventArgs e)
        {
            uxMessageHeader.Width = Width - 415;
        }

        private void uxOKButton_Click(object sender, EventArgs e)
        {
            Start();
        }

        private void uxRevisionList_SelectedIndexChanged(object sender, EventArgs e)
        {           
            uxDeleteButton.Text = "&Delete";
            if (uxRevisionList.SelectedItems.Count > 0)
            {
                uxDeleteButton.Enabled = true;
                foreach (ListViewItem item in uxRevisionList.SelectedItems)
                {
                    if (item.ImageIndex != 1)
                    {
                        return;
                    }
                }
                uxDeleteButton.Text = "&Undelete";
            }
            else
            {
                uxDeleteButton.Enabled = false;
            }
        }

        private void uxDeleteButton_Click(object sender, EventArgs e)
        {
            if (uxDeleteButton.Text.Equals("&Delete"))
            {
                DeleteItems();
            }
            else
            {
                UndeleteItems();
            }
        }
    }
}
